﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace uploader
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            foreach(var file in openFileDialog1.FileNames)
            {
                listBox1.Items.Add(file);
            }
        }

        private void listBox1_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Delete)
            {
                if (e.Control)
                    listBox1.Items.Clear();
                else
                    listBox1.Items.RemoveAt(listBox1.SelectedIndex);
            }
        }

        private async void button2_Click(object sender, EventArgs e)
        {
            button2.Enabled = false;
            try{
                await Task.Run(() => 
                {
                    while ((int)Invoke(new Func<int>(() => { return listBox1.Items.Count; })) > 0)
                    {
                        var item = Invoke(new Func<string>(() => 
                        {
                            var s = listBox1.Items[0] as string;
                            listBox1.Items.RemoveAt(0);
                            return s;
                        }));
                        string args = "upload \"";
                        args += item;
                        args += "\" ";
                        args += textBox1.Text;
                        var psi = new System.Diagnostics.ProcessStartInfo();
                        psi.FileName = "OneDriveView.exe";
                        psi.Arguments = args;
                        psi.WindowStyle = System.Diagnostics.ProcessWindowStyle.Minimized;
                        var p = System.Diagnostics.Process.Start(psi);
                        p.WaitForExit();
                        if (p.ExitCode != 0) break;
                    }
                });
            }
            finally{
                button2.Enabled = true;
            }
        }
    }
}
