﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net.Http;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.IO;


namespace WebWindow
{
    public partial class Form1 : Form
    {
        static private string client_id = "000000004C13458F";
        static private string client_secret = "7qR7I8wn-qQIo5LvXcCIqp1zIu6yay6a";
        static private string scopes = "onedrive.readwrite%20wl.offline_access"; //rw 
        static private string redirect = "https://lithium03.info/login/redirect";
        private string access_code;
        static public string refresh_token;
        static public string access_token;
        static public string error_str;
        public CancellationToken ct;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            webBrowser1.Navigate("https://login.live.com/oauth20_authorize.srf?response_type=code&client_id="
                + client_id + "&scope="
                + scopes + "&redirect_uri=" + Uri.EscapeUriString(redirect));
        }

        static private void ParseResponse(string response)
        {
            var serializer = new DataContractJsonSerializer(typeof(Authentication_Info));
            using (var ms = new MemoryStream(Encoding.UTF8.GetBytes(response)))
            {
                var data = (Authentication_Info)serializer.ReadObject(ms);
                access_token = data.access_token;
                refresh_token = data.refresh_token;
            }
        }

        static public async Task RefreshAuthorizationCode(CancellationToken ct = default(CancellationToken))
        {
            using (var client = new HttpClient())
            {
                try
                {
                    var response = await client.PostAsync(
                        "https://login.live.com/oauth20_token.srf",
                        new FormUrlEncodedContent(new Dictionary<string, string>{
                            {"client_id",Uri.EscapeUriString(client_id)},
                            {"redirect_uri",Uri.EscapeUriString(redirect)},
                            {"client_secret",Uri.EscapeUriString(client_secret)},
                            {"refresh_token",Uri.EscapeUriString(refresh_token)},
                            {"grant_type","refresh_token"}
                        }),
                        ct
                    );
                    response.EnsureSuccessStatusCode();
                    string responseBody = await response.Content.ReadAsStringAsync();
                    // Above three lines can be replaced with new helper method in following line
                    // string body = await client.GetStringAsync(uri);
                    ParseResponse(responseBody);
                }
                catch (HttpRequestException ex)
                {
                    error_str = ex.Message;
                    System.Diagnostics.Debug.WriteLine(error_str);
                }
                catch (Exception ex)
                {
                    error_str = ex.ToString();
                    System.Diagnostics.Debug.WriteLine(error_str);
                }
            }
        }

        private async Task GetAuthorizationCode()
        {
            using (var client = new HttpClient())
            {
                try
                {
                    var response = await client.PostAsync(
                        "https://login.live.com/oauth20_token.srf",
                        new FormUrlEncodedContent(new Dictionary<string, string>{
                            {"client_id",Uri.EscapeUriString(client_id)},
                            {"redirect_uri",Uri.EscapeUriString(redirect)},
                            {"client_secret",Uri.EscapeUriString(client_secret)},
                            {"code",access_code},
                            {"grant_type","authorization_code"}
                        }),
                        ct
                    );
                    response.EnsureSuccessStatusCode();
                    string responseBody = await response.Content.ReadAsStringAsync();
                    // Above three lines can be replaced with new helper method in following line
                    // string body = await client.GetStringAsync(uri);
                    ParseResponse(responseBody);
                }
                catch (HttpRequestException ex)
                {
                    error_str = ex.Message;
                    System.Diagnostics.Debug.WriteLine(error_str);
                }
                catch (Exception ex)
                {
                    error_str = ex.ToString();
                    System.Diagnostics.Debug.WriteLine(error_str);
                }
            }
        }

        private async void webBrowser1_Navigated(object sender, WebBrowserNavigatedEventArgs e)
        {
            string url_redirect = e.Url.ToString();
            this.Text = url_redirect;
            if (url_redirect.IndexOf(redirect) != 0)
                return;
            string code_str = "?code=";
            if (url_redirect.IndexOf(code_str) < 0)
                return;
            access_code = url_redirect.Substring(url_redirect.IndexOf(code_str) + code_str.Length);
            await GetAuthorizationCode();
            timer1.Enabled = true;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Close();
        }

    }

    [DataContract]
    public class Authentication_Info
    {
        [DataMember]
        public string token_type;
        [DataMember]
        public int expires_in;
        [DataMember]
        public string scope;
        [DataMember]
        public string access_token;
        [DataMember]
        public string refresh_token;
        [DataMember]
        public string authentication_token;
    }
}
