﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.IO;

namespace WebWindow
{
    public class LoginLiveID
    {
        const string refresh_filename = "token";
        private Form1 loginForm;
        private string access_token;
        private string refresh_token;
        private string error_str;

        private async Task refresh(CancellationToken ct = default(CancellationToken))
        {
            try
            {
                using (var file = new FileStream(refresh_filename, FileMode.Open, FileAccess.Read, FileShare.Read))
                {
                    var sr = new StreamReader(file);
                    refresh_token = sr.ReadToEnd();
                    Form1.refresh_token = refresh_token;
                }
                await Form1.RefreshAuthorizationCode();
                access_token = Form1.access_token;
                refresh_token = Form1.refresh_token;
                error_str = Form1.error_str;
            }
            catch (Exception ex)
            {
                error_str = ex.ToString();
                System.Diagnostics.Debug.WriteLine(error_str);
            }
        }

        private void savekey()
        {
            try
            {
                using (var file = new FileStream(refresh_filename, FileMode.Create))
                {
                    var sw = new StreamWriter(file);
                    sw.Write(refresh_token);
                    sw.Close();
                }
            }
            catch (Exception ex)
            {
                error_str = ex.ToString();
                System.Diagnostics.Debug.WriteLine(error_str);
            }
        }

        public async Task<string> Login(CancellationToken ct = default(CancellationToken))
        {
            await refresh(ct);
            if (String.IsNullOrEmpty(error_str)) return access_token;
            ct.ThrowIfCancellationRequested();

            Thread t = new Thread(new ThreadStart(() =>
            {
                loginForm = new Form1();
                loginForm.ct = ct;
                loginForm.ShowDialog();
                access_token = Form1.access_token;
                refresh_token = Form1.refresh_token;
                if (!String.IsNullOrEmpty(refresh_token))
                {
                    savekey();
                }
                loginForm.Dispose();
            }));
            t.SetApartmentState(System.Threading.ApartmentState.STA);
            t.Start();
            t.Join();

            return access_token;
        }
    }
}
