﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Threading.Tasks;
using System.Net.Http;
using System.Net.Http.Headers;
using System.IO;
using System.Text;
using System.Threading;
using System.Linq;
using System.Runtime.InteropServices;
using System.Security.Cryptography;
using WebWindow;

namespace OneDrive
{   
    public partial class OneDriveControl
    {
        public const Int64 FileSplitSize = 64 * 1024 * 1024; //max 95MiB 100MB

        // 禁則文字
        static public string ChangeFilenameOneDrive(string filename)
        {
            filename = filename.Replace('／', '_');
            filename = filename.Replace('＊', '.');
            return filename;

        }

        private bool IsEnouphSize(Int64 filesize, string destinationPath)
        {
            // filesizeがfreespaceを超えないように
            // 複数のインスタンスの合計利用サイズがdiskspaceを超えないように
            var drive = new DriveInfo(Path.GetFullPath(destinationPath).Substring(0,1));
            var freespace = drive.AvailableFreeSpace * 0.8;
            var diskspace = drive.TotalSize * 0.8;
            if (filesize > freespace) return false;
            while (true)
            {
                try
                {
                    using (var lockfile = new FileStream(destinationPath + "usespace", FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.None))
                    {
                        Int64 usingspace = 0;
                        if (lockfile.Length > 0)
                        {
                            using (var sr = new BinaryReader(lockfile, Encoding.ASCII, true))
                            {
                                usingspace = sr.ReadInt64();
                            }
                        }
                        if (usingspace + filesize > diskspace) return false;
                        usingspace += filesize;
                        lockfile.Position = 0;
                        using (var sw = new BinaryWriter(lockfile, Encoding.ASCII))
                        {
                            sw.Write(usingspace);
                        }
                    }
                    return true;
                }
                catch
                {
                    continue;
                }
            }
        }

        private void DeleteSize(Int64 filesize, string destinationPath)
        {
            while (true)
            {
                try
                {
                    using (var lockfile = new FileStream(destinationPath + "usespace", FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.None))
                    {
                        Int64 usingspace = 0;
                        if (lockfile.Length > 0)
                        {
                            using (var sr = new BinaryReader(lockfile, Encoding.ASCII, true))
                            {
                                usingspace = sr.ReadInt64();
                            }
                        }
                        usingspace -= filesize;
                        lockfile.Position = 0;
                        using (var sw = new BinaryWriter(lockfile, Encoding.ASCII))
                        {
                            sw.Write(usingspace);
                        }
                    }
                    return;
                }
                catch
                {
                    continue;
                }
            }
        }

        public async Task<int> UploadFileSeparateAsync(string sourcePath, string destination_id, CancellationToken cancellationToken = default(CancellationToken))
        {
            cancellationToken.ThrowIfCancellationRequested();
            //create mother folder
            string destPath = ChangeFilenameOneDrive(Path.GetFileName(sourcePath));

            var motherJson = await CreateFolder_withId(destination_id, destPath, cancellationToken);
            ResponseFolder motherFolder;
            if (!String.IsNullOrEmpty(motherJson))
            {
                var serializer = new DataContractJsonSerializer(typeof(ResponseFolder));
                using (var ms = new MemoryStream(Encoding.UTF8.GetBytes(motherJson)))
                {
                    motherFolder = (ResponseFolder)serializer.ReadObject(ms);
                }
            }
            else return 0;

            // Config.LocalTempDirの大きさが十分ならそちらを使う
            // 足りなければConfig.LocalTempDirBigを使う(こちらは確認しない)
            var usefaster = IsEnouphSize(new FileInfo(sourcePath).Length, Config.LocalTempDir);
            destPath = ((usefaster) ? Config.LocalTempDir : Config.LocalTempDirBig) + destPath;
            Directory.CreateDirectory(destPath);
            try
            {
                int num = await CopyFileSeparateAsync(sourcePath, destPath, cancellationToken);
                await Enumerable.Range(1, num).ForEachAsync(
                    async x =>
                    {
                        string ret = "";
                        while (ret == "")
                        {
                            using (var stream = new FileStream(destPath + "\\" + x.ToString("0000"), FileMode.Open))
                            {
                                ret = await UploadContent_Simple_withId(stream, x.ToString("0000"), motherFolder.id, cancellationToken);
                            }
                            if (ret == "")
                            {
                                // uploadが失敗したが、実はちゃんと上がっている可能性があるのでダウンロードしてみてチェック
                                System.Diagnostics.Debug.WriteLine("item:" + x.ToString("0000") + ":" + errorstr);
                                await Task.Run(() =>
                                {
                                    cancellationToken.WaitHandle.WaitOne(TimeSpan.FromSeconds(10));
                                }, cancellationToken);
                                var children = await GetFolder_id(motherFolder.id, cancellationToken);
                                var newitem = children.value.Find(i => i.name == x.ToString("0000"));
                                if (newitem != null)
                                {
                                    byte[] hash_down, hash_up;
                                    using (var checkbuf = await DownloadBuf(newitem, cancellationToken))
                                    {
                                        hash_down = (new SHA512Managed()).ComputeHash(checkbuf);
                                    }
                                    using (var stream = new FileStream(destPath + "\\" + x.ToString("0000"), FileMode.Open))
                                    {
                                        hash_up = (new SHA512Managed()).ComputeHash(stream);
                                    }
                                    // 一致していたら成功扱いにする
                                    if (hash_down.SequenceEqual(hash_up))
                                        break;
                                }
                            }
                        }
                    }, concurrency: 80, cancellationToken: cancellationToken);

                using (var stream = new FileStream(destPath + "\\" + "0000", FileMode.Open))
                {
                    await UploadContent_Simple_withId(stream, "0000", motherFolder.id, cancellationToken);
                }

                return num;
            }
            finally
            {
                Directory.Delete(destPath, true);
                if (usefaster) DeleteSize(new FileInfo(sourcePath).Length, Config.LocalTempDir);
            }
        }

        const int SaltSize = 16;
        const int myIterations = 10000;

        public async Task<int> CopyFileSeparateAsync(string sourcePath, string destinationPath, CancellationToken cancellationToken = default(CancellationToken))
        {
            int num = 0;
            await Task.Run(() =>
            {
                byte[] salt;
                string orgFilename = Path.GetFileName(sourcePath);
                string password = Config.password_prefix + orgFilename;
                byte[] iv;

                var aes = new RijndaelManaged();
                aes.KeySize = 256;
                aes.BlockSize = 128; //version 0; BlockSize = 256

                new RNGCryptoServiceProvider().GetBytes(salt = new byte[SaltSize]);
                var DeriveBytes = new Rfc2898DeriveBytes(password, salt, myIterations);
                aes.Key = DeriveBytes.GetBytes(aes.KeySize / 8);
                ICryptoTransform encryptor = aes.CreateEncryptor(); 
                iv = aes.IV;
                DeriveBytes.Reset();

                byte[] inbuffer = new byte[encryptor.InputBlockSize];
                byte[] outbuffer = new byte[encryptor.OutputBlockSize];
                Int64 SplitSize = FileSplitSize;
                SHA512Managed hasher = new SHA512Managed();
                using (var source = new FileStream(sourcePath, FileMode.Open, FileAccess.Read, FileShare.Read, bufferSize: 4 * 1024 * 1024, options: FileOptions.SequentialScan))
                {
                    bool finalize = false;
                    while (((SplitSize > 4*1024*1024) && (source.Length / SplitSize) < 40))
                    {
                        SplitSize /= 2;
                    }
                    for (num = 1; source.Position < source.Length; num++)
                    {
                        cancellationToken.ThrowIfCancellationRequested();
                        using (var destination = new FileStream(destinationPath + "\\" + num.ToString("0000"), FileMode.Create, FileAccess.Write, FileShare.Read, bufferSize: 4 * 1024 * 1024, options: FileOptions.SequentialScan))
                        {
                            int bytesRead = 1;
                            Int64 length = Math.Min(source.Length - source.Position, SplitSize);

                            // This will finish silently if we couldn't read "length" bytes.
                            // An alternative would be to throw an exception
                            while (length > 0 && bytesRead > 0)
                            {
                                cancellationToken.ThrowIfCancellationRequested();
                                bytesRead = source.Read(inbuffer, 0, (int)Math.Min(length, inbuffer.Length));
                                if (bytesRead < inbuffer.Length)
                                {
                                    outbuffer = encryptor.TransformFinalBlock(inbuffer, 0, bytesRead);
                                    hasher.TransformFinalBlock(inbuffer, 0, bytesRead);
                                    finalize = true;
                                }
                                else
                                {
                                    encryptor.TransformBlock(inbuffer, 0, inbuffer.Length, outbuffer, 0);
                                    hasher.TransformBlock(inbuffer, 0, inbuffer.Length, inbuffer, 0);
                                }
                                destination.Write(outbuffer, 0, outbuffer.Length);
                                length -= bytesRead;
                            }
                        }
                    }
                    num--;
                    if (!finalize)
                    {
                        using (var destination = new FileStream(destinationPath + "\\" + num.ToString("0000"), FileMode.Append, FileAccess.Write, FileShare.Read, bufferSize: 4 * 1024 * 1024, options: FileOptions.SequentialScan))
                        {
                            outbuffer = encryptor.TransformFinalBlock(inbuffer, 0, 0);
                            hasher.TransformFinalBlock(inbuffer, 0, 0);
                            destination.Write(outbuffer, 0, outbuffer.Length);
                        }
                    }
                }
                byte[] hash = hasher.Hash;
                using (Stream destination = File.Create(destinationPath + "\\0000"))
                {
                    using (var ws = new BinaryWriter(destination, Encoding.Unicode))
                    {
                        int version = 1;
                        num |= (version << 24);
                        ws.Write((Int32)num);
                        ws.Write(iv);
                        ws.Write(salt);
                        ws.Write(orgFilename);
                        ws.Write(hash);
                    }
                }
            }, cancellationToken);
            return num & 0xFFFFFF;
        }
    }
}
