﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace OneDrive
{
    public partial class FormSearch : Form
    {
        public string[] Selected_id;
        OneDriveControl onedrive = new OneDriveControl();
        public FormSearch()
        {
            InitializeComponent();
        }

        private ListViewItem[] convertList(SearchRequest data)
        {
            List<ListViewItem> ret = new List<ListViewItem>();
            foreach (var folder in data.value)
            {
                ListViewItem aItem = new ListViewItem(folder.name);
                if (folder.folder != null)
                {
                    aItem.Tag = folder;
                    ret.Add(aItem);
                }
            }
            return ret.ToArray();
        }

        private async void Button_Go_Click(object sender, EventArgs e)
        {
            var folders = await onedrive.GetFolder_search(textBox1.Text);
            listView1.Items.Clear();
            listView1.Items.AddRange(convertList(folders));
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var item = listView1.SelectedItems;
            if (item == null) Selected_id = null;
            else
            {
                List<string> ret = new List<string>();
                foreach(ListViewItem aitem in item)
                    ret.Add(((ResponseFolder)aitem.Tag).id);
                Selected_id = ret.ToArray();
            }
        }


    }
}
