﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace OneDrive
{
    public partial class FormOneDriveTree : Form
    {
        OneDriveControl onedrive = new OneDriveControl();
        public ResponseFolder selecteditem { get; private set; }
        public string selectedFullpath
        {
            get { return treeView1.SelectedNode.FullPath.Substring(8); }
        }

        private TreeNode[] convertNodes(FolderRequest data)
        {
            List<TreeNode> ret = new List<TreeNode>();
            foreach (var folder in data.value)
            {
                int index = 1;
                if (folder.folder != null)
                    index = 0;
                TreeNode aItem = new TreeNode(folder.name, index, index);
                aItem.Tag = folder;
                ret.Add(aItem);
            }
            return ret.ToArray();
        }

        private async Task CreateRoot()
        {
            if (treeView1.Nodes.Count > 0) return;
            var root = new ResponseFolder();
            root.loaded = true;
            var folders = await onedrive.GetFolder_path();
            treeView1.Nodes.Add("OneDrive");
            treeView1.Nodes[0].Nodes.AddRange(convertNodes(folders));
            treeView1.Nodes[0].Tag = root;
            treeView1.Nodes[0].Expand();
        }

        private async Task DescendTree(TreeNode treeitem)
        {
            var folder = (ResponseFolder)treeitem.Tag;
            if (folder.loaded) return;
            if (folder.folder == null) return;
            toolStripStatusLabel1.Text = "Loading...";
            var folders = await onedrive.GetFolder_id(folder.id);
            treeitem.Nodes.AddRange(convertNodes(folders));
            treeitem.Expand();
            folder.loaded = true;
            toolStripStatusLabel1.Text = "Done.";
        }

        public void SelectItemTree()
        {
            var item = treeView1.SelectedNode;
            if (item == null) selecteditem = (ResponseFolder)treeView1.Nodes[0].Tag;
            else selecteditem = (ResponseFolder)treeView1.SelectedNode.Tag;
        }

        public FormOneDriveTree()
        {
            InitializeComponent();
        }

        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            textBox1.Text = e.Node.FullPath.Substring(8);           
        }

        private async void FormOneDriveTree_Load(object sender, EventArgs e)
        {
            SHSTOCKICONINFO sii = new SHSTOCKICONINFO();
            sii.cbSize = Marshal.SizeOf(sii);
            Win32.SHGetStockIconInfo(Win32.SIID_FOLDEROPEN, Win32.SHGSI_ICON, ref sii);
            if (sii.hIcon != IntPtr.Zero)
            {
                Icon shieldIcon = Icon.FromHandle(sii.hIcon);
                imageList1.Images.Add("test", shieldIcon);
            }
            Win32.SHGetStockIconInfo(Win32.SIID_DOCNOASSOC, Win32.SHGSI_ICON, ref sii);
            if (sii.hIcon != IntPtr.Zero)
            {
                Icon shieldIcon = Icon.FromHandle(sii.hIcon);
                imageList1.Images.Add("test", shieldIcon);
            }
            treeView1.ImageList = imageList1;

            toolStripStatusLabel1.Text = "Loading...";
            await CreateRoot();
            toolStripStatusLabel1.Text = "Done.";
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            SelectItemTree();
        }

        public async Task FollowPathText(string path_str = null)
        {
            if (!String.IsNullOrEmpty(path_str))
            {
                textBox1.Text = path_str;
                await CreateRoot();
            }
            string[] path = textBox1.Text.Split(new char[] { '\\', '/' });
            var item = treeView1.Nodes[0];
            foreach (var p in path)
            {
                if (String.IsNullOrEmpty(p)) continue;
                if (!((ResponseFolder)item.Tag).loaded)
                {
                    await DescendTree(item);
                }
                toolStripStatusLabel1.Text = "";
                var olditem = item;
                foreach (TreeNode node in item.Nodes)
                {
                    if (node.Text == p)
                    {
                        item = node;
                        break;
                    }
                }
                if (olditem == item) break;
            }
            treeView1.SelectedNode = item;
            treeView1.Select();
            SelectItemTree();
        }

        private async void buttonGo_Click(object sender, EventArgs e)
        {
            await FollowPathText();
        }

        private async void treeView1_DoubleClick(object sender, EventArgs e)
        {
            toolStripStatusLabel1.Text = "";
            if (treeView1.SelectedNode == null) return;
            await DescendTree(treeView1.SelectedNode);
        }
    }


    [StructLayoutAttribute(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    struct SHSTOCKICONINFO
    {
        public Int32 cbSize;
        public IntPtr hIcon;
        public Int32 iSysImageIndex;
        public Int32 iIcon;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 260)]
        public string szPath;
    }

    class Win32
    {
        public const UInt32 SHGSI_ICON      = 0x000000100;
        public const UInt32 SHGSI_SMALLICON = 0x000000001;
        public const UInt32 SIID_DOCNOASSOC = 0;
        public const UInt32 SIID_FOLDER     = 3;
        public const UInt32 SIID_FOLDEROPEN = 4;

        [DllImport("shell32.dll", CharSet = CharSet.Unicode)]
        public static extern void SHGetStockIconInfo(UInt32 siid, UInt32 uFlags, ref SHSTOCKICONINFO sii);
    }
}
