﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net.Http;
using System.Net.Http.Headers;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Collections.ObjectModel;
using System.Xml;
using System.Threading;
using System.Runtime.InteropServices;
using WebWindow;

namespace OneDriveView
{
    public partial class Form1 : Form
    {
        private OneDrive.OneDriveControl onedrive = new OneDrive.OneDriveControl();
        private CancellationTokenSource tokenSource = new CancellationTokenSource();

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                var tree = new OneDrive.FormSearch();
                if (tree.ShowDialog(this) == System.Windows.Forms.DialogResult.OK)
                {
                    textBox1.Text = (tree.Selected_id == null) ? "" : tree.Selected_id[0];
                }
            }
            else
            {
                var tree = new OneDrive.FormOneDriveTree();
                if (tree.ShowDialog(this) == System.Windows.Forms.DialogResult.OK)
                {
                    textBox1.Text = tree.selecteditem.id;
                }
            }
        }

        private async void button2_Click(object sender, EventArgs e)
        {
            var tree = new OneDrive.FormOneDriveTree();
            tree.Text = "Select move item";
            string move_target;
            if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            move_target = tree.selecteditem.id;
            tree.Text = "Select move to";
            string move_to;
            if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            move_to = tree.selecteditem.id;
            toolStripStatusLabel1.Text = "move...";
            OneDrive.OneDriveControl onedrive = new OneDrive.OneDriveControl();
            await onedrive.MoveItem_withId(move_target, move_to);
            toolStripStatusLabel1.Text = onedrive.errorstr;
        }

        private async void button3_Click(object sender, EventArgs e)
        {
            tokenSource = new CancellationTokenSource();
            if (openFileDialog1.ShowDialog() != System.Windows.Forms.DialogResult.OK) return;
            var uploadfile = openFileDialog1.FileName;

            var tree = new OneDrive.FormOneDriveTree();
            tree.Text = "Select upload to";
            if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            var move_to = tree.selecteditem.id;
            
            toolStripStatusLabel1.Text = "upload...";
            try
            {
                await onedrive.UploadFileSeparateAsync(uploadfile, move_to, tokenSource.Token);
                toolStripStatusLabel1.Text = "Done.";
            }
            catch (OperationCanceledException)
            {
                toolStripStatusLabel1.Text = "Cancel.";
            }
        }

        private async void button4_Click(object sender, EventArgs e)
        {
            var tree = new OneDrive.FormOneDriveTree();
            tree.Text = "Select delete item";
            string delete_target;
            if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            delete_target = tree.selecteditem.id;

            OneDrive.OneDriveControl onedrive = new OneDrive.OneDriveControl();
            await onedrive.DeleteItem_withId(delete_target);
            toolStripStatusLabel1.Text = onedrive.errorstr;
        }



        private async void button5_Click(object sender, EventArgs e)
        {
            tokenSource = new CancellationTokenSource();
            var tree = new OneDrive.FormOneDriveTree();
            tree.Text = "Select download item";
            if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            var download_target = tree.selecteditem;

            saveFileDialog1.FileName = download_target.name;
            if (saveFileDialog1.ShowDialog() != System.Windows.Forms.DialogResult.OK) return;

            toolStripStatusLabel1.Text = "Download...";
            try
            {
                await onedrive.Download(tree.selectedFullpath, saveFileDialog1.FileName, tokenSource.Token);
                toolStripStatusLabel1.Text = "Done.";
            }
            catch (OperationCanceledException)
            {
                toolStripStatusLabel1.Text = "Cancel.";
            }
        }

        private async void button6_Click(object sender, EventArgs e)
        {
            string[] target_id;
            OneDrive.Config.SendToHost = textBox_host.Text;
            OneDrive.Config.SentToPort = int.Parse(textBox_port.Text);
            if (checkBox1.Checked)
            {
                var tree = new OneDrive.FormSearch();
                if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
                target_id = tree.Selected_id;
            }
            else
            {
                var tree = new OneDrive.FormOneDriveTree();
                tree.Text = "Select download item";
                if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
                target_id = new string[] {tree.selecteditem.id};
            }
            tokenSource.Cancel();
            tokenSource = new CancellationTokenSource();

            foreach (var atarget_id in target_id)
            {
                try
                {
                    toolStripStatusLabel1.Text = "Send...";
                    await onedrive.SendUDP_byId(atarget_id, startsec: double.Parse(textBox_delay.Text), durationsec: double.Parse(textBox_duration.Text), cancellationToken: tokenSource.Token);
                    toolStripStatusLabel1.Text = "Done.";
                }
                catch (OperationCanceledException)
                {
                    toolStripStatusLabel1.Text = "Cancel.";
                }
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            tokenSource.Cancel();
        }
        private async void button9_Click(object sender, EventArgs e)
        {
            tokenSource = new CancellationTokenSource();
            var tree = new OneDrive.FormOneDriveTree();
            tree.Text = "Select Create to";
            if (tree.ShowDialog(this) != System.Windows.Forms.DialogResult.OK) return;
            var create_to = tree.selecteditem.id;

            toolStripStatusLabel1.Text = "mkdir...";
            try
            {
                await onedrive.CreateFolder_withId(create_to, textBox1.Text, tokenSource.Token);
                toolStripStatusLabel1.Text = "Done.";
            }
            catch (OperationCanceledException)
            {
                toolStripStatusLabel1.Text = "Cancel.";
            }
        }


    }

}

