﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.Serialization;
using System.Xml;
using System.IO;

namespace OneDrive
{
    static class Config
    {
        public static string password_prefix = "test";
        public static string LocalTempDir = @"C:\uploadtemp\";
        public static string LocalTempDirBig = @"D:\uploadtemp\";
        public static string SendToHost = "localhost";
        public static int SentToPort = 1240;
        
        static Config()
        {
            string path = System.Windows.Forms.Application.ExecutablePath;
            path = System.IO.Path.ChangeExtension(path,".xml");

            var serializer = new DataContractSerializer(typeof(Savedata));

            try
            {
                using (var xmlr = XmlReader.Create(path))
                {
                    var data = (Savedata)serializer.ReadObject(xmlr);

                    password_prefix = data.password;
                    LocalTempDir = data.first_tempdir;
                    LocalTempDirBig = data.second_tempdir;
                }
            }
            catch (FileNotFoundException)
            {
                using (var xmlw = XmlWriter.Create(path, new XmlWriterSettings { Indent = true }))
                {
                    var data = new Savedata
                    {
                        password = password_prefix,
                        first_tempdir = LocalTempDir,
                        second_tempdir = LocalTempDirBig
                    };
                    serializer.WriteObject(xmlw, data);
                }
            }
            Directory.CreateDirectory(LocalTempDir);
            Directory.CreateDirectory(LocalTempDirBig);
        }
    }

    [DataContract]
    class Savedata
    {
        [DataMember]
        public string password;
        [DataMember]
        public string first_tempdir;
        [DataMember]
        public string second_tempdir;
    }
}
