#!/bin/bash

function __tab(){
	READLINE_LINE="${READLINE_LINE//\</\\<}"
	READLINE_LINE="${READLINE_LINE//\>/\\>}"
	READLINE_LINE="${READLINE_LINE//\|/\\|}"
	READLINE_LINE="${READLINE_LINE//\*/\\\*}"
	local c=${READLINE_LINE//\"}
	local q=$((${#READLINE_LINE}-${#c}))
	if [ $((q % 2)) -eq 1 ]; then
		READLINE_LINE=$READLINE_LINE'"'
		READLINE_POINT=$((READLINE_POINT + 1))
		q=$((q + 1))
	fi
	eval set -- $READLINE_LINE 
	local COMP_WORDS=("$@")
	local COMP_CWORD=0
	local i=$(($READLINE_POINT - $q))
	local c=''
	for c in "$@" ; do

		i=$(($i - ${#c}))
		if [ $i -le 0 ]; then
			break
		fi
		i=$(($i - 1))
		COMP_CWORD=$(($COMP_CWORD + 1))
	done
	unset i c
	local COMPREPLY=()

	local cmp_func
	declare -A cmp_func
	cmp_func["dir"]='_dir'
	cmp_func["ls"]='_dir'
	cmp_func["cd"]='_dir'
	cmp_func["!ls"]='_localfile'
	cmp_func["!pwd"]='_nothing'
	cmp_func["lcd"]='_localfile'
	cmp_func["quit"]='_nothing'
	cmp_func["exit"]='_nothing'
	cmp_func["bye"]='_nothing'
	cmp_func["pwd"]='_nothing'
	cmp_func["mkdir"]='_nothing'
	cmp_func["rmdir"]='_dir'
	cmp_func["get"]='_get'
	cmp_func["put"]='_put'
	cmp_func["mput"]='_mput'
	cmp_func["del"]='_dir'

	for cmd in "${!cmp_func[@]}" ; do
		if [[ "$cmd" == "$1" ]]; then
			${cmp_func["$1"]} "$@"
			if [ ${#COMPREPLY[@]} -eq 1 ]; then
				local cmp_match="${COMPREPLY}"
			else
				local IFS=$'\n' 
				local c_list=($(sort -u <<< "${COMPREPLY[*]}" ))
				unset IFS
				if [[ ${#c_list[@]} -gt 0 ]]; then
					local c_first=${c_list[0]}
					local c_last=${c_list[-1]}
					local c_match=
					for (( i=0; i<=${#c_first} ; i++ ))
					do
						if [[ ${c_first:0: $i} = ${c_last:0: $i} ]]; then
							c_match=$i
						else
							break
						fi
					done
					if [[ $c_match ]]; then
						local cmp_match=${c_first:0:$c_match}
					fi
					echo
					for item in "${COMPREPLY[@]}"; do
						echo $item
					done
				fi
			fi
			if [[ -z $cmp_match ]]; then
				return 0
			fi
			local i=1
			READLINE_LINE="${COMP_WORDS[0]}"
			READLINE_POINT=${#COMP_WORDS[0]}
			while [ $i -lt $# ]; do
				if [ $i -eq $COMP_CWORD ]; then
					local addword="${cmp_match}"
				else
					local addword="${COMP_WORDS[$i]}"
				fi
				if [[ $addword == *\ * ]]; then
					addword='"'"$addword"'"'
				fi
				READLINE_LINE="$READLINE_LINE"' '"${addword}"
				READLINE_POINT=$(($READLINE_POINT + ${#addword} + 1))
				i=$(($i + 1))
			done
			READLINE_POINT=$(($READLINE_POINT + 1))
			return 0
		fi
	done
	COMPREPLY=($(compgen -W "${!cmp_func[*]}" -- "$1"))
	if [ ${#COMPREPLY[@]} -eq 1 ]; then
		shift
		READLINE_LINE="$COMPREPLY"" ""$@"
		READLINE_POINT=${#COMPREPLY}
	else
		echo "${COMPREPLY[@]}"
	fi
}

function _dir(){
	shift
	local dirlist=$(compdirname "$*")
	local cmptarget=${COMP_WORDS[$COMP_CWORD]}
	if [[ $COMP_CWORD -eq 0 ]]; then
		cmptarget=''
	fi
	for (( i=$COMP_CWORD - 1; i > 0; i-- )); do
		if [[ ${COMP_WORDS[$i]} != -* ]]; then
			cmptarget=${COMP_WORDS[$i]}' '$cmptarget
			COMP_WORDS[$i]=$cmptarget
			COMP_WORDS[$i+1]=''
			COMP_CWORD=$i
		fi
	done
	local IFS=$'\n'
	COMPREPLY=($(compgen -W "$dirlist" -- "$cmptarget"))
	unset IFS
}

function _get(){
	local cmptarget=${COMP_WORDS[$COMP_CWORD]}
	if [[ $COMP_CWORD -eq 1 ]]; then
		local dirlist=$(compdirname "$cmptarget")
		local IFS=$'\n'
		COMPREPLY=($(compgen -W "$dirlist" -- "$cmptarget"))
		unset IFS
	else
		local IFS=$'\n'
		COMPREPLY=($(compgen -f -- "$cmptarget"))
		unset IFS
	fi
}

function _put(){
	local cmptarget=${COMP_WORDS[$COMP_CWORD]}
	if [[ $COMP_CWORD -eq 1 ]]; then
		local IFS=$'\n'
		COMPREPLY=($(compgen -f -- "$cmptarget"))
		unset IFS
	else
		local dirlist=$(compdirname "$cmptarget")
		local IFS=$'\n'
		COMPREPLY=($(compgen -W "$dirlist" -- "$cmptarget"))
		unset IFS
	fi
}

function _mput(){
	local cmptarget=${COMP_WORDS[$COMP_CWORD]}
	local IFS=$'\n'
	COMPREPLY=($(compgen -f -- "$cmptarget"))
	unset IFS
}

function _localfile(){	
	local cmptarget=${COMP_WORDS[$COMP_CWORD]}
	local IFS=$'\n'
	COMPREPLY=($(compgen -f -- "$cmptarget"))
	unset IFS
}

function _nothing(){
	:
}
