#!/bin/bash

function parsefolderlist() {
	local target=$1
	listfolder $2 $target >/dev/null

	local path=''
	local name=''
	local category=''
	local mtime=''
	local mount_point=''
	local size=''
	local id=''

	local LINE=''
	local folderitem=()
	while read LINE
	do
		LINE=$(sed -e 's/"\?, "/\n/g' <<<"$LINE")
		path=$(sed -n -e 's/^path": "\(.*\)/\1/p' <<<"$LINE")
		name=$(sed -n -e 's/^name": "\(.*\)/\1/p' <<<"$LINE")
		category=$(sed -n -e 's/.*category": "\(.*\)/\1/p' <<<"$LINE")
		mtime=$(sed -n -e 's/^mtime": \([0-9.]*\)/\1/p' <<<"$LINE")
		mount_point=$(sed -n -e 's/^mount_point": "\(.*\)"/\1/p' <<<"$LINE")
		size=$(sed -n -e 's/^size": \([0-9.]*\)/\1/p' <<<"$LINE")
		id=$(sed -n -e 's/^id": "\(.*\)"/\1/p' <<<"$LINE")
		
		if [ -z "$path" ]; then
			echo error: "$LINE" >&2
			break
		fi
		name=$(sed 's/\xd7/×/g' <<<$name)

		folderitem=("${folderitem[@]}" "${path}")
		list_name[${path}]=$name
		list_category[${path}]=$category
		list_mtime[${path}]=$mtime
		list_size[${path}]=$size
		list_id[${path}]=$id
		case "$category" in
			folders )
				list_mount_point["${path}"]="$mount_point"
				list_folder["${path}"]=''
			;;
		esac
	done < <(echo -e "${jsondata[$target]}" | sed -e 's/}, {/\n/g' | sed -e 's/.*\[{//')
	list_folder["$target"]="${folderitem[@]}"
}

function finddirname(){
	local temp_pwd=${temp_pwd:-$c_path}
	OPTIND=1
	while getopts :en OPT
	do
		case $OPT in
			e ) local encoded=true 	;;
			n ) local encoded='' 	;;
		esac
	done
	shift $((OPTIND - 1))
	local target="$1"
	if [ $encoded ]; then
		if [[ $target == /* ]]; then
			temp_pwd=$target
		else
			temp_pwd=$temp_pwd'/'$target
		fi
		parsefolderlist ${temp_pwd:=/} >/dev/null || return 1
		echo "$temp_pwd"
		return 0
	fi

	if [[ $target == /* ]]; then
		target="${target#/}"
		temp_pwd='/'
	fi
	while [ -n "$target" ]; do
		local r_path="${target%%/*}"
		if [[ $r_path == .. ]]; then
			temp_pwd="${temp_pwd%/*}"
			temp_pwd="${temp_pwd:-/}"
		else
			local enc_r_path=''
			parsefolderlist ${temp_pwd} >/dev/null || return 1
			for item in ${list_folder["$temp_pwd"]}
			do
				if [ "${list_name[$item]}" = "$r_path" ]; then
					enc_r_path="$item"
					break
				fi
			done
			if [ -n "$enc_r_path" ]; then
				temp_pwd=$enc_r_path
				basename="${basename}""${r_path}"'/'
			else
				return 1
			fi
		fi
		target="${target#"$r_path"}"
		target="${target#/}"
	done

	parsefolderlist ${temp_pwd:=/} >/dev/null || return 1
	echo "$temp_pwd"
	return 0
}

function compdirname(){
	local temp_pwd=${temp_pwd:-$c_path}
	OPTIND=1
	while getopts :en OPT
	do
		case $OPT in
			e ) local encoded=true 	;;
			n ) local encoded='' 	;;
		esac
	done
	shift $((OPTIND - 1))
	local target="$*"
	if [ $encoded ]; then
		if [[ $target == /* ]]; then
			temp_pwd=$target
		else
			temp_pwd=$temp_pwd'/'$target
		fi
		temp_pwd="${temp_pwd%/*}"
		parsefolderlist ${temp_pwd:=/} >/dev/null || return 1
		echo "${list_folder["$temp_pwd"]}" | tr ' ' '\n'
		return 0
	fi

	local basename=''
	if [[ $target == /* ]]; then
		target=${target#/}
		temp_pwd='/'
		basename='/'
	fi
	target="${target%/*}"
	while [ -n "$target" ]; do
		local r_path="${target%%/*}"
		if [[ $r_path == .. ]]; then
			temp_pwd="${temp_pwd%/*}"
			temp_pwd="${temp_pwd:-/}"
			basename=$basename"../"
		else
			local enc_r_path=''
			parsefolderlist ${temp_pwd} >/dev/null || return 1
			for item in ${list_folder["$temp_pwd"]}
			do
				if [ "${list_name[$item]}" = "$r_path" ]; then
					enc_r_path="$item"
					break
				fi
			done
			if [ -n "$enc_r_path" ]; then
				temp_pwd=$enc_r_path
				basename=${basename}${r_path}'/'
			else
				break
			fi
		fi
		target="${target#$r_path}"
		target="${target#/}"
	done

	parsefolderlist ${temp_pwd:=/} >/dev/null || return 1
	for item in ${list_folder["$temp_pwd"]}
	do
		echo $basename${list_name[$item]}
	done
	return 0
}

function encpathtofullpath(){
	local uppath=${1%/*}
	if [ -z "$uppath" ]; then
		echo "/${list_name[$1]}"
	else
		echo "$(encpathtofullpath $uppath)""/${list_name[$1]}"
	fi
}

function filenamecheck(){
	if [[ $1 =~ [\<\>:\"/\\|?*] ]]; then
		echo Names may not contain any of the following characters '<>:"/\|?*' >&2
		return 1
	fi
	if [[ $1 =~ ^\. ]]; then
		echo Names may not start with '"."' >&2
		return 1
	fi
	return 0
}
