#!/bin/bash

readonly ClientID=a121b240
readonly ClientSecret=167a85400632f68f1558468521779c91
readonly API=https://developer.api.bitcasa.com/v1
readonly FileAPI=https://files.api.bitcasa.com/v1
readonly cookiefile=cookie.txt
readonly tokenfile=accesstoken.txt

function authlogin() {
	local USER=''
	local PASSWORD=''

	echo "Lon in for developer.api.bitcasa.com"
	echo -n "Input Email:"
	read USER
	stty -echo
	echo -n "Input Password:"
	read PASSWORD
	echo ""
	stty echo

	local cookie="-b $cookiefile -c $cookiefile"
	trap "rm -f $cookiefile" RETURN

	echo "Authentication Login"
	local redirecturl=${API}/oauth2/accessing
	local ret=$(curl -s $cookie ${API}/oauth2/authenticate -G -d client_id=$ClientID -d redirect=$redirecturl)

	local param=$(echo $ret | sed -e "s|.*<form[^>]*>\(.*\)</form>.*|\1|i" | grep -oi -e "<input[^>]*>"  | sed -n -e "h" -e "s/.*name=\"\([^\"]*\)\".*/ --data-urlencode \1=/ip" -e "g" -e "s/.*value=\"\([^\"]*\)\".*/\1  /ip" | tr -d '\n')
	param=$(echo $param | sed -e "s/user=/user=$USER/")
	param=$(echo $param | sed -e "s/password=/password=$PASSWORD/")

	local posturl="${API}/oauth2/authenticate?client_id=$ClientID"
	ret=$(curl -sL $cookie $param -e "$posturl;auto" $posturl -w "\nurl_effective=%{url_effective}")
	local url_eff=$(echo $ret | grep -oi -e "url_effective=.*" | sed -n -e "s/.*url_effective=\(.*\)/\1/p")

	if [[ "$url_eff" == "${API}/oauth2/permission" ]]; then
		echo $ret | grep -oi -e "<h1[^>]*>.*</h1>" | sed -n -e "s|<h1[^>]*>\(.*\)</h1>|##\1##|p"
		echo $ret | grep -oi -e "<h2[^>]*>.*</h2>" | sed -n -e "s|<h2>\(.*\)</h2>| \1|p"
		echo $ret | grep -oi -e "<li>[^<]*</li>" | sed -n -e "s|<li>\(.*\)</li>|\t*)\1|p"
		local selectitem=()
		while read LINE
		do
			selectitem=("${selectitem[@]}" "${LINE}")
		done < <(echo $ret | sed -e "s|.*<form[^>]*>\(.*\)</form>.*|\1|i" | grep -oi -e "<input[^>]*>" | grep -e 'type="submit"')
		PS3='please select > '
		select i in $(echo "${selectitem[@]}" | grep -oi -e 'value="[^"]*"' | sed -n -e 's/value="\([^"]*\)"/\1/p')
		do
			local index=$((${REPLY} - 1))
			if [ -z "$i" ]; then
				continue
			fi
			selectitem=${selectitem[$index]}
			param=$(echo $selectitem | sed -n -e "h" -e "s/.*name=\"\([^\"]*\)\".*/ --data-urlencode \1=/ip" -e "g" -e "s/.*value=\"\([^\"]*\)\".*/\1  /ip" | tr -d '\n')
			break
		done
		param="$param""$(echo $ret | sed -e "s|.*<form[^>]*>\(.*\)</form>.*|\1|i" | grep -oi -e "<input[^>]*>" | grep -v -e 'type="submit"' | sed -n -e "h" -e "s/.*name=\"\([^\"]*\)\".*/ --data-urlencode \1=/ip" -e "g" -e "s/.*value=\"\([^\"]*\)\".*/\1  /ip" | tr -d '\n')"
		local posturl2="${API}/oauth2/permission"
		ret=$(curl -s $cookie $param -e $posturl $posturl2 -w "\nurl_effective=%{url_effective}")
	fi

	local authentication_code=$(echo $ret | grep -oi -e "$redirecturl[^;]*" | sed -n -e "s/.*authorization_code=\(.*\)/\1/ip")

	if [ -z "$authentication_code" ]; then
		echo "Authentication Failed"
		echo $ret
		exit 1
	fi

	echo "Grant access_token"
	#ret=$(curl -s $cookie ${API}/oauth2/access_token -G -d secret=$ClientSecret -d code=$authentication_code)
	ret=$(curl -s ${API}/oauth2/access_token -G -d secret=$ClientSecret -d code=$authentication_code)
	access_token=$(echo $ret | sed -n -e 's/.*"access_token"[^"]*"\([^"]*\)".*/\1/p')

	echo access_token: $access_token
	if [ -z "$access_token" ]; then
		echo "Grant access_token Failed"
		echo $ret
		exit 2
	fi
	echo $access_token >$tokenfile
}

function testtoken(){
	local ret=''
	if [ -e $tokenfile ]; then
		access_token=$(< $tokenfile)
	fi
	if [ -n "$access_token" ]; then
		local fifo=$(mktemp -u)
		local pipe=''
		mkfifo $fifo
		exec {pipe}<>$fifo
		rm $fifo
		trap "exec {pipe}>&-" RETURN

		echo access_token: $access_token
		if listfolder / >&${pipe}; then
			return 0
		fi
		read ret <&${pipe}
	fi
	if [ -n "$ret" ]; then
		echo $ret
		echo
	fi
	authlogin
}

function listfolder(){
	OPTIND=1
	while getopts f OPT
	do
		case $OPT in
			f ) local force=true ;;
		esac
	done
	shift $((OPTIND - 1))
	local target=$1
	if [[ -z "$target" ]]; then
		target='/'
	fi
	if [[ ! $force ]]; then
		if [ -n "${jsondata[$target]}" ]; then
			echo ${jsondata[$target]}
			return 0
		fi
	fi
	local ret=$(curl -s ${API}/folders${target} -G -d access_token=$access_token)
	echo $ret
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		jsondata[$target]=$ret
		return 0
	fi
	return 1
}

function addfolder(){
	local folder=$1
	if [[ -z $folder ]]; then
		echo empty folder name >&2
		return 1
	fi
	filenamecheck "$folder" || return 1

	local ret=$(curl -s -X POST ${API}/folders${c_path}?access_token=$access_token -F "folder_name=$folder")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function deletefolder(){
	local folder=$1
	if [[ -z $folder ]]; then
		echo empty folder name >&2
		return 1
	fi
	local ret=$(curl -s -X DELETE ${API}/folders?access_token=$access_token -F "path=$folder")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function renamefolder(){
	local oldname=$1
	local newname=$2
	if [[ -z $oldname ]]; then
		echo empty '"'from'"' folder name >&2
		return 1
	fi
	filenamecheck "$newname" || return 1
	local ret=$(curl -s -X POST "${API}/folders?operation=rename&access_token=$access_token" -F "from=${oldname}" -F "filename=${newname}")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function copymovefolder(){
	local frompath=$1
	local topath=$2
	local newname=$3
	local cmd=$4
	if [[ -z $frompath ]]; then
		echo empty '"'from'"' folder name >&2
		return 1
	fi
	if [[ -z $topath ]]; then
		echo empty '"'to'"' folder name >&2
		return 1
	fi
	filenamecheck "$newname" || return 1

	local ret=$(curl -s -X POST "${API}/folders?operation=${cmd}&access_token=$access_token" -F "from=${frompath}" -F "to=${topath}" -F "filename=${newname}")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function copyfolder(){
	copymovefolder $1 $2 $3 'copy'
	return $?
}

function movefolder(){
	copymovefolder $1 $2 $3 'move'
	return $?
}

function uploadfile(){
	local targetpath=${1:-/}
	shift
	local filelist=("$@")
	local fileparam=$(for file in "${filelist[@]}"; do echo -e "-F ""file=@${file} "; done)
	echo $(curl -s -X POST "${FileAPI}/files${targetpath}?access_token=$access_token" $fileparam)
}

function downloadfile(){
	OPTIND=1
	while getopts r: OPT
	do
		case $OPT in
			r ) local range=${OPTARG} ;;
		esac
	done
	shift $((OPTIND - 1))
	local target=$1
	local localname=$2

	if [[ -z $target ]]; then
		echo empty download target >&2
		return 1
	fi
	#path
	curl -f -G "${API}/files/test?access_token=$access_token" --data-urlencode "path=$target" -o "${localname:-$target}" ${range:+--range} ${range}
	return $?
}

function deletefile(){
	local target=$1

	local ret=$(curl -s -X DELETE "${API}/files?access_token=$access_token" -F "path=${target}")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function renamefile(){
	local target=$1
	local newname=$2

	if [[ -z $target ]]; then
		echo empty file path >&2
		return 1
	fi
	filenamecheck "$newname" || return 1

	local ret=$(curl -s -X POST "${API}/files?operation=rename&access_token=$access_token" -F "from=${target}" -F "filename=${newname}")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function copymovefile(){
	local frompath=$1
	local topath=$2
	local newname=$3
	local cmd=$4
	if [[ -z $frompath ]]; then
		echo empty '"'from'"' filepath >&2
		return 1
	fi
	if [[ -z $topath ]]; then
		echo empty '"'to'"' filepath >&2
		return 1
	fi
	filenamecheck "$newname" || return 1

	local ret=$(curl -s -X POST "${API}/files?operation=${cmd}&access_token=$access_token" -F "from=${frompath}" -F "to=${topath}" -F "filename=${newname}")
	if [[ $ret =~ \"error\"\ *:\ *null ]]; then
		rdir -f >/dev/null
		return 0
	fi
	echo $ret
	return 2
}

function copyfile(){
	copymovefile $1 $2 $3 'copy'
	return $?
}

function movefile(){
	copymovefile $1 $2 $3 'move'
	return $?
}
