#!/bin/bash

function rdir(){
	OPTIND=1
	while getopts feljinh OPT
	do
		case $OPT in
			f ) local force=true ;;
			e ) local encoded=true ;;
			l ) local longprint=true ;;
			j ) local jsonprint=true ;;
			i ) local idprint=true ;;
			n ) local encoded='' ;;
			h )
				echo -e "\t-f : force reload"
				echo -e "\t-e : encode filename on"
				echo -e "\t-n : encode filename off(default)"
				echo -e "\t-l : long print"
				echo -e "\t-j : print raw json"
				echo -e "\t-i : print file id"
				return 0
			;;
		esac
	done
	shift $((OPTIND - 1))
	local target="$1"
	if [ -z "$target" ]; then
		target=$c_path
	else
		local realname=$target
		target=$(finddirname ${encoded:+-e} $target)
		if [ -z "$target" ]; then
			echo not found path $realname >&2
			return 1
		fi
	fi
	if [ $force ] || [ -z "${list_folder[${target:=/}]}" ]; then
		parsefolderlist "$target" "${force:+-f}"
	fi
	if [ $jsonprint ]; then
		echo -e ${jsondata["$target"]}
	fi
	local item_encoded=(${list_folder["$target"]})
	if [ "$longprint" ]; then
		local itemstr=''
		for item in "${item_encoded[@]}"; do
			case ${list_category["$item"]} in
				folders ) 
					local suffix='/' 
					local filesize=$(printf "%15s" '<dir>')
					local mountpoint="${list_mount_point["$item"]}"
					local fileid=''
				;;
				*)
					local suffix=''
					local filesize=$(printf "%15s" $(awk '{printf"%\047d\n",$1}' <<< "${list_size["$item"]}"))
					local mountpoint=''
					local fileid="${list_id["$item"]}"
				;;
			esac
			itemstr="${item#$target}\t"
			itemstr="$itemstr""$(date "+%Y/%m/%d %T" --date @$(bc <<< "${list_mtime["$item"]:-0} / 1000"))  "
			itemstr="$itemstr""$filesize  "
			itemstr="$itemstr""${list_name["$item"]}${suffix}"
			itemstr="$itemstr""${mountpoint:+"\\t-> "}${mountpoint}"
			if [ $idprint ]; then
				itemstr="$itemstr""${fileid:+"\\n\\t"}${fileid}"
			fi
			echo -e "$itemstr"
		done
		return 0
	fi	
	
	local dirlist_e=()
	local dirlist_n=()
	for item in "${item_encoded[@]}"; do
		case ${list_category["$item"]} in
			folders ) local suffix='/' ;;
			*       ) local suffix=''  ;;
		esac
		dirlist_e=("${dirlist_e[@]}" "${item#$path}${suffix}")
		dirlist_n=("${dirlist_n[@]}" "${list_name["$item"]}${suffix}")
	done
	local IFS=$'\n'
	if [ "$encoded" ]; then
		echo -e "${dirlist_e[*]}"
	else
		echo -e "${dirlist_n[*]}"
	fi
	unset IFS
}


function changedir(){
	OPTIND=1
	while getopts enh OPT
	do
		case $OPT in
			e ) 	local encoded=true ;;
			n ) 	local encoded=''   ;;
			h ) 
				echo -e "\t-e: encoded path"
				echo -e "\t-n: nomal readable path(default)"
			;;
		esac
	done
	shift $((OPTIND - 1))
	local target="$1"
	local old_path=$c_path
	if [[ $target == /* ]]; then
		if [ $encoded ]; then
			if listfolder $target >/dev/null; then
				c_path=$target
				c_name=false
				return 0
			fi
			echo not found encoded path "$target" >&2
			return 1
		fi
		target=${target#/}
		c_path='/'
	fi
	if [ -z "$target" ]; then
		c_path='/'
		c_name=true
		return 0
	fi
	local r_path="${target%%/*}"
	if [[ $r_path == .. ]]; then
		c_path="${c_path%/*}"
		c_path="${c_path:-/}"
	elif [[ $r_path == . ]]; then
		:
	else
		if [ $encoded ]; then
			c_name=false
			if listfolder ${c_path}'/'${r_path} >/dev/null; then
				c_path=${c_path}'/'${r_path}
			else
				c_path=$old_path
				echo not found encoded path ${c_path}'/'${r_path} >&2
				return 1
			fi
		else
			c_name=true
			local enc_r_path=''
			parsefolderlist ${c_path} >/dev/null || { echo not found path ${c_path} >&2 ; return 1; }
			for item in ${list_folder["$c_path"]}
			do
				if [ "${list_name[$item]}" = "$r_path" ]; then
					enc_r_path="$item"
					break
				fi
			done
			if [ -n "$enc_r_path" ]; then
				c_path=$enc_r_path
			else
				c_path=$old_path
				echo not found path ${r_path} >&2
				return 1
			fi
		fi
	fi
	local remain="${target#$r_path}"
	remain="${remain#/}"
	if [ -z "$remain" ]; then
		return 0
	fi
	changedir ${encoded:+-e} "$remain"
}

function rmkdir(){
	OPTIND=1
	while getopts ph OPT
	do
		case $OPT in
			p ) 	local parents=true ;;
			h ) 
				echo -e "\t-p: no error if existing, make parent directories as needed"
			;;
		esac
	done
	shift $((OPTIND - 1))
	local target="$@"
	
	if [[ $target != */* ]]; then
		addfolder $target
		return $?
	fi

	local oldpwd=$c_path
	trap "c_path=$oldpwd" RETURN

	local parent_dir=${target%%/*}
	target=${target#*/}
	
	while true; do
		changedir ${parent_dir:=/} >/dev/null 2>&1
		if [[ $? -ne 0  ]]; then
			addfolder $parent_dir || return $?
			changedir ${parent_dir} >/dev/null 2>&1 || return 4
		elif [[ $parent_dir != / && ! $parents ]]; then
			echo already exists $(encpathtofullpath $c_path) >&2
			return 3
		fi
		if [[ $target != */* ]]; then
			break
		fi
		parent_dir=${target%%/*}
		target=${target#*/}
	done
	changedir $target >/dev/null 2>&1
	if [[ $? -ne 0 ]]; then
		addfolder $target || return $?
		changedir $target >/dev/null 2>&1 || return 4
	elif [[ $target != / && ! $parents ]]; then
		echo already exists $(encpathtofullpath $c_path) >&2
		return 3
	fi
	return 0
}

function rrmdir(){
	OPTIND=1
	while getopts enh OPT
	do
		case $OPT in
			e ) 	local encoded=true ;;
			n ) 	local encoded=''   ;;
			h ) 
				echo -e "\t-e: encoded path"
				echo -e "\t-n: nomal readable path(default)"
			;;
		esac
	done
	shift $((OPTIND - 1))
	local target="$@"
	
	local oldpwd=$c_path
	trap "c_path=$oldpwd" RETURN

	changedir ${encoded:+-e} ${target} >/dev/null 2>&1 || echo not found path ${target} || return 1
	deletefolder $c_path || return $?

	target="${c_path%/*}"
	parsefolderlist ${target:=/} -f
	if [[ $c_path = $oldpwd ]]; then
		c_path=$target
		trap "" RETURN
	fi
	return 0
	
}

function renamedir(){
	local oldname="$1"
	local newname="$2"
	
	if [[ $target == */* ]]; then
		echo newname must be only name >&2
		return 1
	fi

	local oldpwd=$c_path
	trap "c_path=$oldpwd" RETURN

	changedir ${encoded:+-e} ${oldname} >/dev/null 2>&1 || echo not found path ${oldname} || return 1
	renamefolder "$c_path" "$newname" || return $?	

	local target="${c_path%/*}"
	parsefolderlist ${target:=/} -f
}

function rget(){
	OPTIND=1
	while getopts r: OPT
	do
		case $OPT in
			r ) local range=${OPTARG} ;;
		esac
	done
	shift $((OPTIND - 1))
	local remotetarget="$1"
	local localtarget="$2"
	if [[ ! $range =~ [0-9,-]* ]]; then
		range=''
	fi

	local oldpwd=$c_path
	trap "c_path=$oldpwd" RETURN
	
	changedir "$remotetarget" >/dev/null 2>&1 || echo not found path ${remotetarget} >&2 || return 1

	trap "" RETURN
	c_path=$oldpwd

	local fileid=${list_id["$(finddirname "$remotetarget")"]} || return $?
	if [[ -z $fileid ]]; then
		echo file id not found >&2
		return 1
	fi

	localtarget=${localtarget:-${remotetarget##*/}}
	downloadfile ${range:+-r} ${range} $fileid $localtarget
}

function rput(){
	local localtarget="$1"
	local remotetarget="$2"

	local oldpwd=$c_path
	trap "c_path=$oldpwd" RETURN
	
	changedir "$remotetarget" >/dev/null 2>&1 || echo not found path ${remotetarget} >&2 || return 1

	uploadfile $c_path $localtarget
}

function mput(){
	local target=()
	for item in "$@"; do
		local list=($(eval find . -name $item))
		target=("${target[@]}" "${list[@]}")
	done

	uploadfile $c_path "${target[@]}"
}

function rdel(){
	local target="$@"
	
	local oldpwd=$c_path
	trap "c_path=$oldpwd" RETURN

	changedir ${target} >/dev/null 2>&1 || echo not found path ${target} || return 1
	deletefile $c_path || return $?

	target="${c_path%/*}"
	parsefolderlist ${target:=/} -f
	if [[ $c_path = $oldpwd ]]; then
		c_path=$target
		trap "" RETURN
	fi
	return 0
}
