#pragma once

class BitcasaFileItem;

std::wstring RemoteFileHash(BitcasaAPI& API, std::string fileid, INT64 filesize, HashFilter::Hash hashtype);

bool CheckFilePathMatch(tstring& str, std::wstring& testpath,bool regular = false);
int listBitcasa(BitcasaAPI& API, param::paramdata& param);
std::vector<BitcasaFileItem> remotesearch(BitcasaAPI& API, param::paramdata& param);


class BitcasaFileItem {
public:
	std::wstring name;
	std::string path;
	std::string id;
	std::string mount_point;
	INT64 size = 0;
	FILETIME LastWriteTime;
	FILETIME CreationTime;
	FILETIME BirthTime;
	std::wstring namepath_parent;
	std::wstring namepath(){
		return (name.empty()) ? L"" : namepath_parent + L"\\" + name;
	}
	bool vagrant = false;
	std::wstring hashstr;
	std::wstring display;
	std::wstring attribute;

	BitcasaFileItem(){};
	BitcasaFileItem(json_object jsonItem);

	static std::wstring gouppath(std::wstring path);
	static std::string gouppath(std::string path);
	static std::string rootparent(std::wstring path);
	static std::unordered_map<std::string, std::vector<BitcasaFileItem>> BitcasaItemList;
	static std::unordered_map<std::string, std::wstring> BitcasaEncToNameList;
	static std::unordered_map<std::wstring, std::string> BitcasaNameToEncList;
	static std::unordered_map<std::string, BitcasaFileItem> BitcasaVagrantList;
};



class BitcasaServer {
private:
	BitcasaAPI& API;
	
	std::vector<BitcasaFileItem> DirBitcasa(std::string path, bool deep);

public:
	std::vector<BitcasaFileItem> listBitcasaDir(std::wstring target, bool deep);

	BitcasaServer(BitcasaAPI& aAPI)
		: API(aAPI)
	{
		BitcasaFileItem::BitcasaEncToNameList["/"] = L"\\";
		BitcasaFileItem::BitcasaNameToEncList[L"\\"] = "/";
	}
};
