#pragma once

namespace param {

	typedef struct {
		bool regular;
		bool recursion;
		bool notree;
		tstring targetstr;
		tstring basepath;
	} remote_param;

	typedef struct {
		bool regular;
		bool recursion;
		bool notree;
		tstring targetstr;
		tstring basepath;
	} local_param;

	enum modetype { null, list, local, diff };

	typedef struct {
		modetype mode;
		bool verbose;
		bool usedatefilter;
		FILETIME startdate;
		FILETIME enddate;
		bool usesizefilter;
		INT64 minsize;
		INT64 maxsize;
		bool ignoretime;
		bool ignoresize;
		HashFilter::Hash hashtype;
		remote_param remote;
		local_param local;
	} paramdata;

}

#ifdef _WIN64
const FINDEX_INFO_LEVELS findex_flag = FindExInfoBasic;
#else
const FINDEX_INFO_LEVELS findex_flag = FindExInfoStandard;
#endif // _WIN64

#ifdef _WIN64
typedef	ULONGLONG Tick;
#define GetTick	GetTickCount64
#else
typedef	DWORD Tick;
#define GetTick	GetTickCount
#endif // _WIN64
