#pragma once

class BitcasaFileItem;

bool CheckFilePathMatch(tstring& str, std::wstring& testpath,bool regular = false);
int listBitcasa(BitcasaDLL::BitcasaWrapper^ API, param::paramdata& param);
std::vector<BitcasaFileItem> remotesearch(BitcasaDLL::BitcasaWrapper^ API, param::paramdata& param);


class BitcasaFileItem {
public:
	std::wstring name;
	std::string path;
	std::string id;
	std::string mount_point;
	INT64 size = 0;
	FILETIME LastWriteTime;
	std::wstring namepath_parent;
	std::wstring namepath(){
		return (name.empty()) ? L"" : namepath_parent + L"\\" + name;
	}
	std::wstring display;

	BitcasaFileItem() {};
	BitcasaFileItem(BitcasaDLL::json_objectWrapper^ jsonItem);

	static std::wstring gouppath(std::wstring path);
	static std::string gouppath(std::string path);
	static std::unordered_map<std::string, std::vector<BitcasaFileItem>> BitcasaItemList;
	static std::unordered_map<std::string, std::wstring> BitcasaEncToNameList;
	static std::unordered_map<std::wstring, std::string> BitcasaNameToEncList;
};



ref class BitcasaServer {
private:
	BitcasaDLL::BitcasaWrapper^ API;
	
	std::vector<BitcasaFileItem> DirBitcasa(std::string path, bool deep);

public:
	std::vector<BitcasaFileItem> listBitcasaDir(std::wstring target, bool deep);

	BitcasaServer(BitcasaDLL::BitcasaWrapper^ aAPI)
		: API(aAPI)
	{
	}

	static BitcasaServer()
	{
		BitcasaFileItem::BitcasaEncToNameList["/"] = L"\\";
		BitcasaFileItem::BitcasaNameToEncList[L"\\"] = "/";
	}
};
