﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using BitcasaDLL;

namespace bitcasaViewer
{
    public partial class FormDiff : Form
    {
        List<string> diffItemList;
        string leftpath;
        string rightpath;

        class item
        {
            public bool left;
            public bool right;
            public string key;

            public item(string K, bool L, bool R)
            {
                key = K;
                left = L;
                right = R;
            }
        }

        public FormDiff()
        {
            InitializeComponent();
            diffItemList = new List<string>();
        }

        public void diff(string localrootdir, string prefix, bool save)
        {
            SortedDictionary<string, item> difflist = new SortedDictionary<string, item>();
            
            leftpath = localrootdir;
            rightpath = prefix;
            label1.Text = "left : " + leftpath;
            label2.Text = "right: " + rightpath;

            //right(remote)
            foreach(string akey in BitcasaFileInfo.BitcasaDrive.Keys)
            {
                string key = akey;
                if (key.IndexOf(prefix) == 0)
                {
                    key = key.Substring(prefix.Length).TrimStart('\\');
                }
                else
                {
                    continue;
                }
                if (key == "") continue;
                if (BitcasaFileInfo.BitcasaDrive[akey].name == null) continue;
                difflist[key] = new item(akey, false, true);
            }
            //left(local)
            foreach (ListLocalBitcasa akey in ListLocalBitcasa.ListDir(localrootdir))
            {
                string key = akey.name;
                string dkey = key;
                const string infstr = "Bitcasa Infinite Drive\\";
                if (key.IndexOf(localrootdir) == 0)
                {
                    dkey = key.Substring(localrootdir.Length);
                    key = (localrootdir == "I:\\") ? infstr + dkey : dkey;
                }
                if (key == "") continue;
                item olditem;
                if (difflist.TryGetValue(dkey, out olditem))
                {
                    olditem.left = true;
                    if(save)
                        BitcasaFileInfo.BitcasaDrive[olditem.key].localinfo = akey;
                }
                else
                {
                    difflist[dkey] = new item(key, true, false);
                    if (save)
                    {
                        BitcasaFileInfo.BitcasaDrive["\\" + key] = new BitcasaFileInfo();
                        BitcasaFileInfo.BitcasaDrive["\\" + key].localinfo = akey;
                    }
                }
            }
            diffItemList.Clear();
            foreach (KeyValuePair<string, item> pair in difflist)
            {
                diffItemList.Add(
                    ((pair.Value.left) ? "L" : " ") +
                    ((pair.Value.right) ? "R" : " ") +
                    " "+
                    pair.Key);
            }
            listBox1.BeginUpdate();
            listBox1.Items.Clear();
            foreach (string item in diffItemList)
            {
                if (item.IndexOf("LR ") == 0)
                    continue;
                listBox1.Items.Add(item);
            }
            listBox1.EndUpdate();
        }

        private void listBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            // Draw the background of the ListBox control for each item.
            e.DrawBackground();
            if (e.Index > -1)
            {
                if ((e.State & DrawItemState.Selected) != DrawItemState.Selected)
                {
                    if (listBox1.Items[e.Index].ToString()[0] != 'L')
                        e.Graphics.FillRectangle(Brushes.DarkSeaGreen, new RectangleF(e.Bounds.X, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height));
                    if (listBox1.Items[e.Index].ToString()[1] != 'R')
                        e.Graphics.FillRectangle(Brushes.Salmon, new RectangleF(e.Bounds.X, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height));
                }

                Brush myBrush = new SolidBrush(listBox1.ForeColor);

                e.Graphics.DrawString(listBox1.Items[e.Index].ToString(),
                    e.Font, myBrush, e.Bounds, StringFormat.GenericDefault);
            }
            // If the ListBox has focus, draw a focus rectangle around the selected item.
            e.DrawFocusRectangle();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            listBox1.BeginUpdate();
            listBox1.Items.Clear();
            foreach (string item in diffItemList)
            {
                if (item.IndexOf("LR ") == 0)
                    continue;
                listBox1.Items.Add(item);
            }
            listBox1.EndUpdate();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            listBox1.BeginUpdate();
            listBox1.Items.Clear();
            listBox1.Items.AddRange(diffItemList.ToArray<string>());
            listBox1.EndUpdate();
        }


    }
}
