﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace bitcasaViewer
{
    public partial class FormFind : Form
    {
        public string findstr
        {
            get { return comboBox1.Text; }
        }
        public bool IsRegular
        {
            get { return checkBox_regular.Checked; }
        }
        static public DateTime InvalidDate = new DateTime(1900, 1, 1, 0, 0, 0, DateTimeKind.Utc);
        public Int64 sizemin = -1;
        public Int64 sizemax = -1;
        public DateTime datemin = InvalidDate;
        public DateTime datemax = InvalidDate;

        public FormFind()
        {
            InitializeComponent();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (comboBox1.Items.IndexOf(comboBox1.Text) < 0)
            {
                comboBox1.Items.Add(comboBox1.Text);
                comboBox1.AutoCompleteCustomSource.Add(comboBox1.Text);
            }
        }

        private void textBox_sizemin_TextChanged(object sender, EventArgs e)
        {
            Int64 size;
            if (Int64.TryParse(textBox_sizemin.Text, out size))
            {
                sizemin = size;
            }
            else
            {
                textBox_sizemin.Text = "";
                sizemin = -1;
            }
        }

        private void textBox_sizemax_TextChanged(object sender, EventArgs e)
        {
            Int64 size;
            if (Int64.TryParse(textBox_sizemax.Text, out size))
            {
                sizemax = size;
            }
            else
            {
                textBox_sizemax.Text = "";
                sizemax = -1;
            }
        }

        private void textBox_daymin_Leave(object sender, EventArgs e)
        {
            try
            {
                datemin = DateTime.Parse(textBox_datemin.Text);
            }
            catch
            {
                datemin = InvalidDate;
                textBox_datemin.Text = "";
            }
        }

        private void textBox_datemax_Leave(object sender, EventArgs e)
        {
            try
            {
                datemax = DateTime.Parse(textBox_datemax.Text);
            }
            catch
            {
                datemax = InvalidDate;
                textBox_datemax.Text = "";
            }
        }
    }
}
