﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace bitcasaViewer
{
    public partial class BitcasaTreeSelect : Form
    {
        Form1 owner;
        public string SelectedPath
        {
            get {
                var Node = treeView1.SelectedNode;
                if (Node == null) return "";
                return Node.FullPath.Substring(4);
            }
        }

        public BitcasaTreeSelect(Form1 aOwner)
        {
            InitializeComponent();
            owner = aOwner;
        }

        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            var Node = treeView1.SelectedNode;
            if (Node == null) return;
            var selectItem = Node.FullPath.Substring(4);

            lock (typeof(BitcasaFileInfo))
            {
                Node.Nodes.Clear();
                var treeitems = owner.ListChildren(selectItem);
                foreach (BitcasaFileInfo items in treeitems)
                {
                    Node.Nodes.Add(items.name);
                }
                Node.Expand();
            }
        }

        private void BitcasaTreeSelect_Shown(object sender, EventArgs e)
        {
            treeView1.Nodes.Clear();
            treeView1.Nodes.Add("root");
        }
    }
}
