﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections;
using System.Windows.Forms;
using BitcasaDLL;

namespace bitcasaViewer
{
    class BitcasaServer
    {
        private BitcasaWrapper bitcasa = new BitcasaWrapper();
        public bool loadall_flag { get; protected set; }

        public delegate void delegateProgressBar(int v);

        public bool login()
        {
            return bitcasa.prepare();
        }

        public BitcasaFileInfo reloadDir(string fullpath, delegateProgressBar callback)
        {
            lock (typeof(BitcasaFileInfo))
            {
                fullpath = fullpath.TrimEnd('\\');
                BitcasaFileInfo.dirLoaded[fullpath] = false;
                return loadDir(fullpath, callback);
            }
        }

        public BitcasaFileInfo loadDir(string fullpath, delegateProgressBar callback)
        {
            lock (typeof(BitcasaFileInfo))
            {
                fullpath = fullpath.TrimEnd('\\');
                var dirItem = BitcasaFileInfo.dirTree[fullpath];
                if (!BitcasaFileInfo.dirLoaded[fullpath])
                {
                    if (callback != null) callback(50);
                    var result = bitcasa.ListFolder(dirItem.path);
                    if (callback != null) callback(75);
                    BitcasaFileInfo.dirLoaded[fullpath] = true;
                    var root = result["result"]["items"];
                    for (uint i = 0; i < root.size; i++)
                    {
                        var item = root.Items(i);
                        BitcasaFileInfo.GetItem((item as json_objectWrapper), "");
                    }
                }
                if (callback != null) callback(100);
                return dirItem;
            }
        }

        public void loadALL(delegateProgressBar callback)
        {
            lock (typeof(BitcasaFileInfo))
            {
                BitcasaFileInfo.clearDictionary();
                if (callback != null) callback(25);
                var result = bitcasa.ListFolder("/", true);
                var root = result["result"]["items"];
                if (callback != null) callback(75);
                BitcasaFileInfo.dirLoaded[""] = true;
                BitcasaFileInfo.dirLoaded["\\"] = true;
                for (uint i = 0; i < root.size; i++)
                {
                    var item = root.Items(i);
                    var path = BitcasaFileInfo.GetItem((item as json_objectWrapper), "").fullpath;
                    BitcasaFileInfo.dirLoaded[path] = true;
                }
                loadall_flag = true;
                if (callback != null) callback(100);
            }
        }

        public BitcasaFileInfo[] listChild(string parentpath)
        {
            lock (typeof(BitcasaFileInfo))
            {
                ArrayList result = new ArrayList();
                foreach (var item in BitcasaFileInfo.dirTree.SkipWhile(x => !x.Key.StartsWith(parentpath)).TakeWhile(x => x.Key.StartsWith(parentpath)))
                {
                    if ((item.Key != parentpath) && (item.Key.Substring(parentpath.Length + 1).IndexOf('\\') < 0))
                        result.Add(item.Value);
                }

                return (BitcasaFileInfo[])result.ToArray(typeof(BitcasaFileInfo));
            }
        }

        public bool download(BitcasaFileInfo target, string localfilename, delegateProgressBar callback)
        {
            if (target.id == "") return false;
            Int64 size = target.size;
            var ret = bitcasa.DownloadFile(
                target.id, 
                localfilename,
                size,
                new filetrans(
                    (Int64 pos)=>{
                        if (callback != null)
                        {
                            System.Console.Error.WriteLine("pos:" + pos.ToString());
                            System.Console.Error.WriteLine("size:" + size.ToString());
                            callback((int)(100.0 * pos / size));
                        }
                    })
                );
            return ret;
        }

        public bool upload(BitcasaFileInfo targetdir, string localfilename, delegateProgressBar callback)
        {
            if(callback != null) callback(0);
            if (targetdir.path == "") return false;
            Int64 filesize = 1;
            var ret = bitcasa.UploadFile(
                targetdir.path, 
                localfilename,
                new filetrans(
                    (Int64 pos) =>
                    {
                        if (callback != null)
                        {
                            if ((pos >= 0) && (filesize < pos)) filesize = pos;
                            if (pos < 0) callback((int)pos);
                            else callback((int)(100.0 * (filesize-pos) / filesize));
                        }
                    })
                );
            return ret;
        }

        public bool rename(BitcasaFileInfo target, string newname, delegateProgressBar callback)
        {
            bool ret = true;
            if(callback != null) callback(0);
            if(newname == "") return false;
            if(callback != null) callback(25);
            if (target.category == "folders")
            {
                ret = bitcasa.RenameFolder(target.path, newname);
            }
            else
            {
                ret = bitcasa.RenameFile(target.path, newname);
            }
            lock (typeof(BitcasaFileInfo))
            {
                BitcasaFileInfo.dirTree.Remove(target.fullpath);
            }
            if(callback != null) callback(50);
            reloadDir(BitcasaFileInfo.pathtoparent(target.path), null);
            if (callback != null) callback(100);
            return ret;
        }
        
        public bool moveitem(BitcasaFileInfo[] oldpaths, BitcasaFileInfo newpath, delegateProgressBar callback)
        {
            bool ret = true;
            int progress = 25;
            if(callback != null) callback(progress);
            if (newpath.path == "") return false;
            foreach(BitcasaFileInfo oldpath in oldpaths){
                if (oldpath.category == "folders")
                {
                    ret = bitcasa.MoveFolder(oldpath.path, newpath.path, oldpath.name);
                }
                else
                {
                    ret = bitcasa.MoveFile(oldpath.path, newpath.path, oldpath.name);
                }
                if (!ret) break;
                lock (typeof(BitcasaFileInfo))
                {
                    BitcasaFileInfo.dirTree.Remove(oldpath.fullpath);
                }
                if (callback != null) callback(progress+=(50/oldpaths.Length));
            }
            reloadDir(newpath.fullpath, null);
            if(callback != null) callback(100);
            return ret;
        }
        
        public bool copyitem(BitcasaFileInfo[] oldpaths, BitcasaFileInfo newpath, delegateProgressBar callback)
        {
            bool ret = true;
            int progress = 25;
            if (callback != null) callback(progress);
            if (newpath.path == "") return false;
            foreach (BitcasaFileInfo oldpath in oldpaths)
            {
                if (oldpath.category == "folders")
                {
                    ret = bitcasa.CopyFolder(oldpath.path, newpath.path, oldpath.name);
                }
                else
                {
                    ret = bitcasa.CopyFile(oldpath.path, newpath.path, oldpath.name);
                }
                if (!ret) break;
                lock (typeof(BitcasaFileInfo))
                {
                    BitcasaFileInfo.dirTree.Remove(oldpath.fullpath);
                }
                if (callback != null) callback(progress += (50 / oldpaths.Length));
            }
            reloadDir(newpath.fullpath, null);
            if (callback != null) callback(100);
            return ret;
        }

        public bool mkDir(BitcasaFileInfo targetdir, string newname, delegateProgressBar callback)
        {
            bool ret = true;
            if (callback != null) callback(0);
            if (newname == "") return false;
            if (targetdir.category != "folders") return false;
            if (callback != null) callback(25);
            ret = bitcasa.AddFolder(targetdir.path, newname);
            if (callback != null) callback(50);
            lock (typeof(BitcasaFileInfo))
            {
                reloadDir(BitcasaFileInfo.pathtoparent(targetdir.path), null);
            }
            if (callback != null) callback(100);
            return ret;
        }
        public bool deleteitem(BitcasaFileInfo[] targets, delegateProgressBar callback)
        {
            bool ret = true;
            int progress = 25;
            if (callback != null) callback(progress);
            foreach (BitcasaFileInfo target in targets)
            {
                if (target.category == "folders")
                {
                    ret = bitcasa.DeleteFolder(target.path);
                }
                else
                {
                    ret = bitcasa._DeleteFile(target.path);
                }
                if (!ret) break;
                lock (typeof(BitcasaFileInfo))
                {
                    BitcasaFileInfo.dirTree.Remove(target.fullpath);
                }
                if (callback != null) callback(progress += (50 / targets.Length));
            }
            if (callback != null) callback(100);
            return ret;
        }
    }
}
