﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using BitcasaDLL;

namespace bitcasaViewer
{

    class FileInfo
    {
        public static SortedDictionary<string, FileInfo> dirTree;
        public static SortedDictionary<string, string> PathDirMap;
        public static SortedDictionary<string, bool> dirLoaded;
        public static void clearDictionary()
        {
            dirTree.Clear();
            PathDirMap.Clear();
            FileInfo newItem = new FileInfo();
            newItem.name = "\\";
            newItem.path = "/";
            dirTree[newItem.fullpath] = newItem;
            dirTree[""] = newItem;
            PathDirMap[""] = "";
            PathDirMap["/"] = "";
            dirLoaded[""] = false;
            dirLoaded["\\"] = false;
        }

        public string parentpath;
        //common
        public string category;
        public string name;
        public double mtime;
        public string path;
        public int type;
        //folder
        public string mount_point;
        public bool mirrored;
        public string origin_device;
        public string origin_device_id;
        public string sync_type;
        //file
        public string manifest_name;
        public string id;
        public bool incomplete;
        public Int64 size;

        public string fullpath
        {
            get { return parentpath + name; }
        }

        static FileInfo()
        {
            dirTree = new SortedDictionary<string, FileInfo>();
            PathDirMap = new SortedDictionary<string, string>();
            dirLoaded = new SortedDictionary<string, bool>();
            clearDictionary();
        }

        public static string pathtoparent(string path)
        {
            string parent = path.Substring(0, path.LastIndexOf('/'));
            return PathDirMap[parent]+"\\";
        }

        public static FileInfo GetItem(json_objectWrapper Item, string parent)
        {
            FileInfo newItem = new FileInfo();

            newItem.parentpath = (parent == "") ? pathtoparent(Item["path"].GetString()) : parent;

            jsonitemWrapper entry;
            entry = Item["category"];
            newItem.category = entry.GetString();
            entry = Item["name"];
            newItem.name = entry.GetString();
            entry = Item["mtime"];
            newItem.mtime = entry.GetDouble();
            entry = Item["path"];
            newItem.path = entry.GetString();
            entry = Item["type"];
            newItem.type = (int)entry.GetDouble();
            //folder
            entry = Item["mount_point"];
            newItem.mount_point = entry.GetString();
            entry = Item["mirrored"];
            newItem.mirrored = entry.GetBool();
            entry = Item["origin_device"];
            newItem.origin_device = entry.GetString();
            entry = Item["origin_device_id"];
            newItem.origin_device_id = entry.GetString();
            entry = Item["sync_type"];
            newItem.sync_type = entry.GetString();
            //file
            entry = Item["manifest_name"];
            newItem.manifest_name = entry.GetString();
            entry = Item["id"];
            newItem.id = entry.GetString();
            entry = Item["incomplete"];
            newItem.incomplete = entry.GetBool();
            entry = Item["size"];
            newItem.size = entry.GetInteger();

            dirTree[newItem.fullpath] = newItem;
            PathDirMap[newItem.path] = newItem.fullpath;
            dirLoaded[newItem.fullpath] = false;

            return newItem;
        }
        public static FileInfo GetItem(json_objectWrapper Item)
        {
            return GetItem(Item, "\\");
        }
        private readonly static DateTime UnixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);
        public static string mtimeToString(double mtime)
        {
            DateTime mtime2 = UnixEpoch.AddMilliseconds(mtime).ToLocalTime();
            return mtime2.ToString("yyyy/MM/dd HH:mm:ss");
        }
        public static double DateTimeTomtime(DateTime t)
        {
            return t.ToUniversalTime().Subtract(UnixEpoch).TotalMilliseconds;
        }
    }
}
