﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Collections;


namespace bitcasaViewer
{
    public partial class Form1 : Form
    {
        private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
        {
            bool folder_flag = false;
            bool file_flag = false;
            downloadToolStripMenuItem.Enabled = false;
            uploadToolStripMenuItem.Enabled = false;
            renameToolStripMenuItem.Enabled = false;
            moveToolStripMenuItem.Enabled = false;
            copyToolStripMenuItem.Enabled = false;
            mkDirToolStripMenuItem.Enabled = false;
            foreach (ListViewItem listitem in listView1.SelectedItems)
            {
                if ((listitem.SubItems[0].Text == ".") || (listitem.SubItems[0].Text == ".."))
                {
                    folder_flag = true;
                    continue;
                }
                var item = FileInfo.dirTree[listitem.SubItems[3].Text];
                if (item.id != "")
                {
                    file_flag = true;
                    continue;
                }
                if (item.category == "folders")
                    folder_flag = true;
            }
            if (file_flag && folder_flag)
            {
                return;
            }
            downloadToolStripMenuItem.Enabled = file_flag;
            uploadToolStripMenuItem.Enabled = ((listView1.SelectedItems.Count == 1) && folder_flag);
            renameToolStripMenuItem.Enabled = (listView1.SelectedItems.Count == 1);
            mkDirToolStripMenuItem.Enabled = ((listView1.SelectedItems.Count == 1) && folder_flag);
            if (SelectedFiles.Count < 1)
            {
                moveToolStripMenuItem.Enabled = true;
                moveToolStripMenuItem.Text = "Move ...";
                copyToolStripMenuItem.Enabled = true;
                copyToolStripMenuItem.Text = "Copy ...";
            }
            else
            {
                moveToolStripMenuItem.Enabled = ((listView1.SelectedItems.Count == 1) && folder_flag);
                moveToolStripMenuItem.Text = "Move here";
                copyToolStripMenuItem.Enabled = ((listView1.SelectedItems.Count == 1) && folder_flag);
                copyToolStripMenuItem.Text = "Copy here";
            }
        }

        private void downloadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (listView1.SelectedItems.Count == 1)
            {
                var item = FileInfo.dirTree[listView1.SelectedItems[0].SubItems[3].Text];
                if (item.id == "") return;
                saveFileDialog1.FileName = item.name;
                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    if (!bitcasa.download(item, saveFileDialog1.FileName, this.progress))
                    {
                        MessageBox.Show("download failed.");
                        progress(0);
                    }
                    progress(100);
                }
            }
            if (listView1.SelectedItems.Count > 1)
            {
                if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
                {
                    foreach (ListViewItem listitem in listView1.SelectedItems)
                    {
                        var item = FileInfo.dirTree[listitem.SubItems[3].Text];
                        if (item.id == "") continue;

                        if (!bitcasa.download(item, folderBrowserDialog1.SelectedPath + "\\" + item.name, this.progress))
                        {
                            MessageBox.Show("download failed.");
                            progress(0);
                            break;
                        }
                        progress(100);
                    }
                }
            }
        }

        private void uploadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var item = SelectItemToFileinfo();
            if (item.path == "") return;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if (!bitcasa.upload(item, openFileDialog1.FileName, this.progress))
                    MessageBox.Show("upload not completed(failed or too slow response).");
            }
            if (checkBox_reload.Checked)
                reloadview();
        }

        private void mkDirToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var item = SelectItemToFileinfo();
            if (item.path == "") return;
            var dialog = new FormInput();
            dialog.LabelText = "enter new name";
            dialog.InputString = "";
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                if (dialog.InputString == item.name) return;
                if (dialog.InputString == "") return;

                if (!bitcasa.mkDir(item, dialog.InputString, this.progress))
                {
                    MessageBox.Show("AddFolder failed.");
                    return;
                }
            }
            if (checkBox_reload.Checked)
                reloadview();
        }

        private void renameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var seletedItem = listView1.SelectedItems[0];
            if ((seletedItem.SubItems[0].Text == ".") || (seletedItem.SubItems[0].Text == "..")) return;
            var item = FileInfo.dirTree[seletedItem.SubItems[3].Text];
            var dialog = new FormInput();
            dialog.LabelText = "enter new name";
            dialog.InputString = item.name;
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                if (dialog.InputString == item.name) return;
                if (!bitcasa.rename(item, dialog.InputString, this.progress))
                {
                    MessageBox.Show("Rename failed.");
                    return;
                }
            }
            if (checkBox_reload.Checked)
                reloadview();
        }

        private void pushSelectedList()
        {
            foreach (ListViewItem listitem in listView1.SelectedItems)
            {
                var item = FileInfo.dirTree[listitem.SubItems[3].Text];
                if (item.name == "") continue;
                SelectedFiles.Add(item);
            }
        }

        private void moveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (SelectedFiles.Count < 1)
            {
                pushSelectedList();
            }
            else
            {
                var item = SelectItemToFileinfo();
                if (item.path == "") return;
                if (!bitcasa.moveitem((FileInfo[])SelectedFiles.ToArray(typeof(FileInfo)), item, this.progress))
                    MessageBox.Show("Move failed.");
                SelectedFiles.Clear();
            }
            if (checkBox_reload.Checked)
                reloadview();
        }

        private void copyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (SelectedFiles.Count < 1)
            {
                pushSelectedList();
            }
            else
            {
                var item = SelectItemToFileinfo();
                if (item.path == "") return;
                if (!bitcasa.copyitem((FileInfo[])SelectedFiles.ToArray(typeof(FileInfo)), item, this.progress))
                    MessageBox.Show("Copy failed.");
                SelectedFiles.Clear();
            }
            if (checkBox_reload.Checked)
                reloadview();
        }

        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ArrayList delFiles = new ArrayList();

            foreach (ListViewItem listitem in listView1.SelectedItems)
            {
                if ((listitem.SubItems[0].Text == ".") || (listitem.SubItems[0].Text == "..")) continue;
                var item = FileInfo.dirTree[listitem.SubItems[3].Text];
                if (item.name == "") continue;
                delFiles.Add(item);
            }
            if (!bitcasa.deleteitem((FileInfo[])delFiles.ToArray(typeof(FileInfo)), this.progress))
                MessageBox.Show("Copy failed.");
            if (checkBox_reload.Checked)
                reloadview();
        }
    }
}
