#pragma once

#include "stdafx.h"

class HttpsClient
{
public:
	HttpsClient();
	~HttpsClient();

private:
	BIO *bio;
	SSL *ssl;
	SSL_SESSION *sess;
	SSL_CTX *ctx;
	X509 *cert;
	BIO *cbio;

	int send();
	int sendfile(std::ifstream& infile, std::string filename);
	std::string ReadLine();

public:
	std::vector<char> buffer;
	struct {
		std::string line;
		std::string URI;
		std::multimap<std::string, std::string> header;
		std::map<std::string, std::string> query;
		std::vector<char> body;
	} request;
	struct {
		std::string line;
		int code;
		std::string reason;
		std::multimap<std::string, std::string> header;
		std::vector<char> body;
	} response;

	int AddHeader(std::string key, std::string value);
	std::string GetResponseHeader(std::string key);

	int GET(std::string URI);
	int POST(std::string URI);
	int POST(std::string URI, std::map<std::string,std::string> formdata);
	int POSTfile(std::string URI, std::map<std::string, std::string> formdata, std::wstring filename);
	int _DELETE(std::string URI);
	int _DELETE(std::string URI, std::map<std::string, std::string> formdata);

	int Print();
	int Clear();
	void Reset() { if(bio) BIO_reset(bio); }
};

